<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @package Lifestyle\Sylius\Account\Consumer\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @inheritDoc
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_sylius_account_consumer')
                ->children()
                    ->arrayNode('account')
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('address')
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('customergroup')
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
