<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\DependencyInjection;

use Lifestyle\Sylius\Account\Consumer\MessageHandler\AccountPublishHandler;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\AccountUnpublishHandler;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\AddressPublishHandler;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\AddressUnpublishHandler;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\CustomerGroupPublishHandler;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\CustomerGroupUnpublishHandler;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

/**
 * Class LifestyleSyliusAccountConsumerExtension
 *
 * @package Lifestyle\Sylius\Account\Consumer\DependencyInjection
 */
class LifestyleSyliusAccountConsumerExtension extends Extension
{
    /**
     * @inheritDoc
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new YamlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))->load('services.yml');

        $this->configureMessageHandler(AccountPublishHandler::class, 'account', 'publish', $config, $container);
        $this->configureMessageHandler(AccountUnpublishHandler::class, 'account', 'unpublish', $config, $container);

        $this->configureMessageHandler(AddressPublishHandler::class, 'address', 'publish', $config, $container);
        $this->configureMessageHandler(AddressUnpublishHandler::class, 'address', 'unpublish', $config, $container);

        $this->configureMessageHandler(CustomerGroupPublishHandler::class, 'customergroup', 'publish', $config, $container);
        $this->configureMessageHandler(CustomerGroupUnpublishHandler::class, 'customergroup', 'unpublish', $config, $container);
    }

    /**
     * @param string $serviceId
     * @param string $type
     * @param string $event
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureMessageHandler(
        string $serviceId,
        string $type,
        string $event,
        array $config,
        ContainerBuilder $container
    ) {
        if (!$container->has($serviceId)) {
            return;
        }

        $definition = $container->findDefinition($serviceId);

        $responsibleEvents = isset($config[$type]['responsible_events'][$event]) ? $config[$type]['responsible_events'][$event] : [];
        foreach ($responsibleEvents as $responsibleEvent) {
            $definition->addMethodCall('addResponsibleEvent', [$responsibleEvent]);
        }
    }
}
