<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Services\CustomerGroup\Version1;

use Doctrine\ORM\EntityManager;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\Services\Shared\Helper\DatabaseTrait;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Component\Customer\Model\CustomerGroupInterface;
use Sylius\Component\Resource\Factory\FactoryInterface as ResourceFactory;

/**
 * Class CustomerGroupServiceHandler
 *
 * @package Lifestyle\Sylius\Account\Consumer\Services\CustomerGroup\Version1
 */
class CustomerGroupServiceHandler implements HandlerInterface
{
    const HANDLER_ID = 'CustomerGroup';

    use DatabaseTrait;

    /**
     * @var ResourceFactory
     */
    private $customerGroupFactory;

    /**
     * @var EntityRepository
     */
    private $customerGroupRepository;

    /**
     * @var EntityManager
     */
    private $customerGroupManager;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * CustomerGroupServiceHandler constructor.
     *
     * @param ResourceFactory  $customerGroupFactory
     * @param EntityRepository $customerGroupRepository
     * @param EntityManager    $customerGroupManager
     * @param LoggerInterface  $logger
     */
    public function __construct(
        ResourceFactory $customerGroupFactory,
        EntityRepository $customerGroupRepository,
        EntityManager $customerGroupManager,
        LoggerInterface $logger
    ) {
        $this->customerGroupFactory = $customerGroupFactory;
        $this->customerGroupRepository = $customerGroupRepository;
        $this->customerGroupManager = $customerGroupManager;
        $this->logger = $logger;
    }

    /**
     * @inheritDoc
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $collector->getItemValue('className') === self::HANDLER_ID;
    }

    /**
     * @inheritDoc
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        try {
            // reconnect database if connection was lost
            $this->customerGroupManager = $this->getClearedEntityManager($this->customerGroupManager);

            $customerGroupEntity = $this->customerGroupRepository->findOneBy(['code' => $collector->getItemValue('id')]);

            if (null === $customerGroupEntity) {
                /** @var CustomerGroupInterface $customerGroupEntity */
                $customerGroupEntity = $this->customerGroupFactory->createNew();
                $customerGroupEntity->setCode($collector->getItemValue('id'));
            }

            $customerGroupEntity->setName($collector->getItemValue('name'));

            $this->customerGroupRepository->add($customerGroupEntity);
            $this->logger->info('Saved customer group: ' . $collector->getItemValue('name'));
        } catch (\Exception $exception) {
            $this->logger->error($exception->getMessage());
        }
    }

    /**
     * @inheritDoc
     */
    public function delete(DataCollectorInterface $collector)
    {
        // customer groups will currently not be deleted
    }
}
