<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Tests\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\CustomerGroupPublishHandler;
use Lifestyle\Sylius\Account\Consumer\Services\CustomerGroup\Version1\CustomerGroupServiceHandler;
use PHPUnit\Framework\TestCase;

/**
 * Class CustomerGroupPublishHandlerTest
 *
 * @package Lifestyle\Sylius\Account\Consumer\Tests\MessageHandler
 */
class CustomerGroupPublishHandlerTest extends TestCase
{
    public function testHandleTrue()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('customergroup:publish');

        $messageHandlerMock = $this->getMockBuilder(CustomerGroupServiceHandler::class)->disableOriginalConstructor()->getMock();
        $messageHandlerMock->expects($this->once())->method('isResponsible')->with($this->equalTo($dataCollectorMock))->willReturn(true);
        $messageHandlerMock->expects($this->once())->method('createOrUpdate')->with($this->equalTo($dataCollectorMock));

        $testObj = new CustomerGroupPublishHandler();
        $testObj->addResponsibleEvent('customergroup:publish');
        $testObj->addMessageHandler($messageHandlerMock);

        $this->assertTrue($testObj->handle($dataCollectorMock));
    }

    public function testHandleFalseByNotResponsible()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('invalid:event');

        $testObj = new CustomerGroupPublishHandler();
        $testObj->addResponsibleEvent('customergroup:publish');

        $this->assertFalse($testObj->handle($dataCollectorMock));
    }

    public function testHandleFalseByMessageHandlerNotResponsible()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('customergroup:publish');

        $messageHandlerMock = $this->getMockBuilder(CustomerGroupServiceHandler::class)->disableOriginalConstructor()->getMock();
        $messageHandlerMock->expects($this->once())->method('isResponsible')->with($this->equalTo($dataCollectorMock))->willReturn(false);
        $messageHandlerMock->expects($this->never())->method('createOrUpdate');

        $testObj = new CustomerGroupPublishHandler();
        $testObj->addResponsibleEvent('customergroup:publish');
        $testObj->addMessageHandler($messageHandlerMock);

        $this->assertFalse($testObj->handle($dataCollectorMock));
    }
}
