<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Entity;

use Sylius\Component\Resource\Model\ResourceInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Location
 *
 * @package Lifestyle\Sylius\Account\Consumer\Entity
 */
class Location implements ResourceInterface
{
    /**
     * @var int
     */
    private $id;

    /**
     * @Assert\NotBlank
     * @Assert\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Assert\NotNull
     * @Assert\Type("Lifestyle\Sylius\Account\Consumer\Entity\Address")
     * @var Address
     */
    private $billingAddress;

    /**
     * @Assert\NotNull
     * @Assert\Type("Lifestyle\Sylius\Account\Consumer\Entity\Address")
     * @var Address
     */
    private $shippingAddress;

    /**
     * @Assert\Type("float")
     * @var float
     */
    private $geopointLatitude;

    /**
     * @Assert\Type("float")
     * @var float
     */
    private $geopointLongitude;

    /**
     * @Assert\NotBlank
     * @Assert\Type("int")
     * @var int
     */
    private $code;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Location
     */
    public function setName(string $name): Location
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int $code
     *
     * @return Location
     */
    public function setCode(int $code): Location
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return Address
     */
    public function getBillingAddress(): Address
    {
        return $this->billingAddress;
    }

    /**
     * @param Address $billingAddress
     *
     * @return Location
     */
    public function setBillingAddress(Address $billingAddress): Location
    {
        $this->billingAddress = $billingAddress;

        return $this;
    }

    /**
     * @return Address
     */
    public function getShippingAddress(): Address
    {
        return $this->shippingAddress;
    }

    /**
     * @param Address $shippingAddress
     *
     * @return Location
     */
    public function setShippingAddress(Address $shippingAddress): Location
    {
        $this->shippingAddress = $shippingAddress;

        return $this;
    }

    /**
     * @return float
     */
    public function getGeopointLatitude(): float
    {
        return $this->geopointLatitude;
    }

    /**
     * @param float $geopointLatitude
     *
     * @return Location
     */
    public function setGeopointLatitude(float $geopointLatitude): Location
    {
        $this->geopointLatitude = $geopointLatitude;

        return $this;
    }

    /**
     * @return float
     */
    public function getGeopointLongitude(): float
    {
        return $this->geopointLongitude;
    }

    /**
     * @param float $geopointLongitude
     *
     * @return Location
     */
    public function setGeopointLongitude(float $geopointLongitude): Location
    {
        $this->geopointLongitude = $geopointLongitude;

        return $this;
    }
}
