<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Tests\Services\Account\Version1;

use Doctrine\DBAL\Connection;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManager;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\Entity\Address;
use Lifestyle\Sylius\Account\Consumer\Entity\Customer;
use Lifestyle\Sylius\Account\Consumer\Services\Account\Version1\AccountServiceHandler;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\AddressRepository;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\CustomerRepository;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Component\Customer\Model\CustomerGroupInterface;
use Sylius\Component\Resource\Factory\FactoryInterface as ResourceFactory;
use Sylius\Component\User\Model\UserInterface;

/**
 * Class AccountServiceHandlerTest
 *
 * @package Lifestyle\Sylius\Account\Consumer\Tests\Services\Account\Version1
 */
class AccountServiceHandlerTest extends TestCase
{
    public function testIsResponsibleTrue()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('className'))->willReturn('Account');

        $customerFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $shopUserFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();

        $testObj = new AccountServiceHandler(
            $customerFactoryMock,
            $customerRepositoryMock,
            $customerManagerMock,
            $addressRepositoryMock,
            $customerGroupRepositoryMock,
            $shopUserFactoryMock,
            $loggerMock
        );

        $this->assertTrue($testObj->isResponsible($dataCollectorMock));
    }

    public function testIsResponsibleFalse()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('className'))->willReturn('InvalidClass');

        $customerFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $shopUserFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();

        $testObj = new AccountServiceHandler(
            $customerFactoryMock,
            $customerRepositoryMock,
            $customerManagerMock,
            $addressRepositoryMock,
            $customerGroupRepositoryMock,
            $shopUserFactoryMock,
            $loggerMock
        );

        $this->assertFalse($testObj->isResponsible($dataCollectorMock));
    }

    public function testCreateOrUpdateCreate()
    {
        $code = 128;
        $firstName = 'testFN';
        $lastName = 'testLN';
        $email = 'testEmail';
        $phoneNumber = 'testPhoneNumber';
        $companyName = 'testCompanyName';
        $taxId = 'testTaxId';
        $customerGroupId = 222;
        $billingAddressId = 333;
        $shippingAddressId = 444;

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(13))->method('getItemValue')
            ->withConsecutive(
                [$this->equalTo('id')],
                [$this->equalTo('id')],
                [$this->equalTo('firstName')],
                [$this->equalTo('lastName')],
                [$this->equalTo('email')],
                [$this->equalTo('phoneNumber')],
                [$this->equalTo('companyName')],
                [$this->equalTo('taxId')],
                [$this->equalTo('CustomerGroup')],
                [$this->equalTo('BillingAddress')],
                [$this->equalTo('ShippingAddress')],
                [$this->equalTo('email')],
                [$this->equalTo('email')]
            )
            ->willReturnOnConsecutiveCalls(
                $code,
                $code,
                $firstName,
                $lastName,
                $email,
                $phoneNumber,
                $companyName,
                $taxId,
                $customerGroupId,
                $billingAddressId,
                $shippingAddressId,
                $email,
                $email
            );

        $customerGroupEntityMock = $this->getMockBuilder(CustomerGroupInterface::class)->disableOriginalConstructor()->getMock();
        $addressEntityMock = $this->getMockBuilder(Address::class)->disableOriginalConstructor()->getMock();
        $shopUserEntityMock = $this->getMockBuilder(UserInterface::class)->disableOriginalConstructor()->getMock();
        $shopUserEntityMock->expects($this->once())->method('setEnabled')->with($this->equalTo(true));
        $shopUserEntityMock->expects($this->once())->method('setUsername')->with($this->equalTo($email));

        $customerEntityMock = $this->getMockBuilder(Customer::class)->disableOriginalConstructor()->getMock();
        $customerEntityMock->expects($this->once())->method('setCode')->with($this->equalTo($code));
        $customerEntityMock->expects($this->once())->method('setGroup')->with($this->equalTo($customerGroupEntityMock));
        $customerEntityMock->expects($this->once())->method('setDefaultAddress')->with($this->equalTo($addressEntityMock));
        $customerEntityMock->expects($this->once())->method('addAddress')->with($this->equalTo($addressEntityMock));
        $customerEntityMock->expects($this->once())->method('getUser')->willReturn(null);
        $customerEntityMock->expects($this->once())->method('setUser')->with($this->equalTo($shopUserEntityMock));

        $customerFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerFactoryMock->expects($this->once())->method('createNew')->willReturn($customerEntityMock);
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock->expects($this->once())->method('findOneBy')->willReturn(null);
        $customerRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($customerEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock->expects($this->exactly(2))->method('findOneBy')->willReturn($addressEntityMock);
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock->expects($this->once())->method('findOneBy')->with()->willReturn($customerGroupEntityMock);

        $shopUserFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $shopUserFactoryMock->expects($this->once())->method('createNew')->willReturn($shopUserEntityMock);

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();

        $testObj = new AccountServiceHandler(
            $customerFactoryMock,
            $customerRepositoryMock,
            $customerManagerMock,
            $addressRepositoryMock,
            $customerGroupRepositoryMock,
            $shopUserFactoryMock,
            $loggerMock
        );

        $testObj->createOrUpdate($dataCollectorMock);
    }

    public function testCreateOrUpdateUpdate()
    {
        $code = 128;
        $firstName = 'testFN';
        $lastName = 'testLN';
        $email = 'testEmail';
        $phoneNumber = 'testPhoneNumber';
        $companyName = 'testCompanyName';
        $taxId = 'testTaxId';
        $customerGroupId = 222;
        $billingAddressId = 333;
        $shippingAddressId = 444;

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(12))->method('getItemValue')
            ->withConsecutive(
                [$this->equalTo('id')],
                [$this->equalTo('firstName')],
                [$this->equalTo('lastName')],
                [$this->equalTo('email')],
                [$this->equalTo('phoneNumber')],
                [$this->equalTo('companyName')],
                [$this->equalTo('taxId')],
                [$this->equalTo('CustomerGroup')],
                [$this->equalTo('BillingAddress')],
                [$this->equalTo('ShippingAddress')],
                [$this->equalTo('email')],
                [$this->equalTo('email')]
            )
            ->willReturnOnConsecutiveCalls(
                $code,
                $firstName,
                $lastName,
                $email,
                $phoneNumber,
                $companyName,
                $taxId,
                $customerGroupId,
                $billingAddressId,
                $shippingAddressId,
                $email,
                $email
            );

        $customerGroupEntityMock = $this->getMockBuilder(CustomerGroupInterface::class)->disableOriginalConstructor()->getMock();
        $addressEntityMock = $this->getMockBuilder(Address::class)->disableOriginalConstructor()->getMock();
        $shopUserEntityMock = $this->getMockBuilder(UserInterface::class)->disableOriginalConstructor()->getMock();
        $shopUserEntityMock->expects($this->never())->method('setEnabled');
        $shopUserEntityMock->expects($this->once())->method('setUsername')->with($this->equalTo($email));

        $customerEntityMock = $this->getMockBuilder(Customer::class)->disableOriginalConstructor()->getMock();
        $customerEntityMock->expects($this->never())->method('setCode');
        $customerEntityMock->expects($this->once())->method('setGroup')->with($this->equalTo($customerGroupEntityMock));
        $customerEntityMock->expects($this->once())->method('setDefaultAddress')->with($this->equalTo($addressEntityMock));
        $customerEntityMock->expects($this->once())->method('addAddress')->with($this->equalTo($addressEntityMock));
        $customerEntityMock->expects($this->once())->method('getUser')->willReturn($shopUserEntityMock);
        $customerEntityMock->expects($this->never())->method('setUser');

        $customerFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerFactoryMock->expects($this->never())->method('createNew');
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock->expects($this->once())->method('findOneBy')->willReturn($customerEntityMock);
        $customerRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($customerEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock->expects($this->exactly(2))->method('findOneBy')->willReturn($addressEntityMock);
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock->expects($this->once())->method('findOneBy')->with()->willReturn($customerGroupEntityMock);

        $shopUserFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $shopUserFactoryMock->expects($this->never())->method('createNew');

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();

        $testObj = new AccountServiceHandler(
            $customerFactoryMock,
            $customerRepositoryMock,
            $customerManagerMock,
            $addressRepositoryMock,
            $customerGroupRepositoryMock,
            $shopUserFactoryMock,
            $loggerMock
        );

        $testObj->createOrUpdate($dataCollectorMock);
    }

    public function testCreateOrUpdateException()
    {
        $code = 128;
        $errorMessage = 'someTestError';

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(1))->method('getItemValue')
            ->withConsecutive([$this->equalTo('id')])
            ->willReturnOnConsecutiveCalls($code);

        $shopUserEntityMock = $this->getMockBuilder(UserInterface::class)->disableOriginalConstructor()->getMock();
        $shopUserEntityMock->expects($this->never())->method('setEnabled');

        $customerEntityMock = $this->getMockBuilder(Customer::class)->disableOriginalConstructor()->getMock();
        $customerEntityMock->expects($this->never())->method('setCode');

        $customerFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerFactoryMock->expects($this->never())->method('createNew');
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock->expects($this->once())->method('findOneBy')->willThrowException(new \Exception($errorMessage));
        $customerRepositoryMock->expects($this->never())->method('add');

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();

        $shopUserFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $loggerMock->expects($this->once())->method('error')->with($this->equalTo($errorMessage));

        $testObj = new AccountServiceHandler(
            $customerFactoryMock,
            $customerRepositoryMock,
            $customerManagerMock,
            $addressRepositoryMock,
            $customerGroupRepositoryMock,
            $shopUserFactoryMock,
            $loggerMock
        );

        $testObj->createOrUpdate($dataCollectorMock);
    }

    public function testDelete()
    {
        $code = 128;

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(2))->method('getItemValue')
            ->withConsecutive([$this->equalTo('id')], [$this->equalTo('id')])
            ->willReturnOnConsecutiveCalls($code, $code);

        $shopUserEntityMock = $this->getMockBuilder(UserInterface::class)->disableOriginalConstructor()->getMock();
        $shopUserEntityMock->expects($this->once())->method('setEnabled')->with($this->equalTo(false));

        $customerEntityMock = $this->getMockBuilder(Customer::class)->disableOriginalConstructor()->getMock();
        $customerEntityMock->expects($this->exactly(2))->method('getUser')->willReturn($shopUserEntityMock);

        $customerFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock = $this->getMockBuilder(CustomerRepository::class)->disableOriginalConstructor()->getMock();
        $customerRepositoryMock->expects($this->once())->method('findOneBy')->willReturn($customerEntityMock);
        $customerRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($customerEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $shopUserFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();

        $testObj = new AccountServiceHandler(
            $customerFactoryMock,
            $customerRepositoryMock,
            $customerManagerMock,
            $addressRepositoryMock,
            $customerGroupRepositoryMock,
            $shopUserFactoryMock,
            $loggerMock
        );

        $testObj->delete($dataCollectorMock);
    }
}
