<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Tests\Services\Location\Version1;

use Doctrine\DBAL\Connection;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManager;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\Entity\Address;
use Lifestyle\Sylius\Account\Consumer\Entity\Location;
use Lifestyle\Sylius\Account\Consumer\Services\Location\Version1\LocationServiceHandler;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\AddressRepository;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Component\Resource\Factory\FactoryInterface as ResourceFactory;

/**
 * Class LocationServiceHandlerTest
 *
 * @package Lifestyle\Sylius\Account\Consumer\Tests\Services\Location\Version1
 */
class LocationServiceHandlerTest extends TestCase
{
    public function testIsResponsibleTrue()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('className'))->willReturn('Location');

        $locationFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $locationRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $locationManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new LocationServiceHandler($locationFactoryMock, $locationRepositoryMock, $locationManagerMock, $addressRepositoryMock, $loggerMock);

        $this->assertTrue($testObj->isResponsible($dataCollectorMock));
    }

    public function testIsResponsibleFalse()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('className'))->willReturn('InvalidClass');

        $locationFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $locationRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $locationManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new LocationServiceHandler($locationFactoryMock, $locationRepositoryMock, $locationManagerMock, $addressRepositoryMock, $loggerMock);

        $this->assertFalse($testObj->isResponsible($dataCollectorMock));
    }

    public function testCreateOrUpdateCreate()
    {
        $code = 123;
        $name = 'location123';
        $billingAddress = 456;
        $shippingAddress = 789;
        $latitude = 1.23456789;
        $longitude = 9.87654321;
        $geolocation = ['Latitude' => $latitude, 'Longitude' => $longitude];

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(1))->method('hasItem')->willReturn(true);
        $dataCollectorMock->expects($this->exactly(8))->method('getItemValue')
            ->withConsecutive(
                [$this->equalTo('id')],
                [$this->equalTo('id')],
                [$this->equalTo('name')],
                [$this->equalTo('BillingAddress')],
                [$this->equalTo('ShippingAddress')],
                [$this->equalTo('geoLocation')],
                [$this->equalTo('geoLocation')],
                [$this->equalTo('id')]
            )
            ->willReturnOnConsecutiveCalls(
                $code,
                $code,
                $name,
                $billingAddress,
                $shippingAddress,
                $geolocation,
                $geolocation,
                $code
            );

        $addressEntityMock = $this->getMockBuilder(Address::class)->disableOriginalConstructor()->getMock();

        $newLocationEntityMock = $this->getMockBuilder(Location::class)->disableOriginalConstructor()->getMock();
        $newLocationEntityMock->expects($this->once())->method('setCode')->with($this->equalTo($code));
        $newLocationEntityMock->expects($this->once())->method('setName')->with($this->equalTo($name));
        $newLocationEntityMock->expects($this->once())->method('setBillingAddress')->with($this->equalTo($addressEntityMock));
        $newLocationEntityMock->expects($this->once())->method('setShippingAddress')->with($this->equalTo($addressEntityMock));
        $newLocationEntityMock->expects($this->once())->method('setGeopointLatitude')->with($this->equalTo($latitude));
        $newLocationEntityMock->expects($this->once())->method('setGeopointLongitude')->with($this->equalTo($longitude));

        $locationFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $locationFactoryMock->expects($this->once())->method('createNew')->willReturn($newLocationEntityMock);

        $locationRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $locationRepositoryMock->expects($this->once())->method('findOneBy')->willReturn(null);
        $locationRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($newLocationEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $locationManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $locationManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $locationManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $locationManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock->expects($this->exactly(2))->method('findOneBy')->willReturn($addressEntityMock);

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new LocationServiceHandler($locationFactoryMock, $locationRepositoryMock, $locationManagerMock, $addressRepositoryMock, $loggerMock);

        $testObj->createOrUpdate($dataCollectorMock);
    }

    public function testCreateOrUpdateUpdate()
    {
        $code = 123;
        $name = 'location123';
        $billingAddress = 456;
        $shippingAddress = 789;
        $latitude = 1.23456789;
        $longitude = 9.87654321;
        $geolocation = ['Latitude' => $latitude, 'Longitude' => $longitude];

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(1))->method('hasItem')->willReturn(true);
        $dataCollectorMock->expects($this->exactly(7))->method('getItemValue')
            ->withConsecutive(
                [$this->equalTo('id')],
                [$this->equalTo('name')],
                [$this->equalTo('BillingAddress')],
                [$this->equalTo('ShippingAddress')],
                [$this->equalTo('geoLocation')],
                [$this->equalTo('geoLocation')],
                [$this->equalTo('id')]
            )
            ->willReturnOnConsecutiveCalls(
                $code,
                $name,
                $billingAddress,
                $shippingAddress,
                $geolocation,
                $geolocation,
                $code
            );

        $addressEntityMock = $this->getMockBuilder(Address::class)->disableOriginalConstructor()->getMock();

        $locationEntityMock = $this->getMockBuilder(Location::class)->disableOriginalConstructor()->getMock();
        $locationEntityMock->expects($this->never())->method('setCode');
        $locationEntityMock->expects($this->once())->method('setName')->with($this->equalTo($name));
        $locationEntityMock->expects($this->once())->method('setBillingAddress')->with($this->equalTo($addressEntityMock));
        $locationEntityMock->expects($this->once())->method('setShippingAddress')->with($this->equalTo($addressEntityMock));
        $locationEntityMock->expects($this->once())->method('setGeopointLatitude')->with($this->equalTo($latitude));
        $locationEntityMock->expects($this->once())->method('setGeopointLongitude')->with($this->equalTo($longitude));

        $locationFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $locationFactoryMock->expects($this->never())->method('createNew');

        $locationRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $locationRepositoryMock->expects($this->once())->method('findOneBy')->willReturn($locationEntityMock);
        $locationRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($locationEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $locationManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $locationManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $locationManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $locationManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $addressRepositoryMock = $this->getMockBuilder(AddressRepository::class)->disableOriginalConstructor()->getMock();
        $addressRepositoryMock->expects($this->exactly(2))->method('findOneBy')->willReturn($addressEntityMock);

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new LocationServiceHandler($locationFactoryMock, $locationRepositoryMock, $locationManagerMock, $addressRepositoryMock, $loggerMock);

        $testObj->createOrUpdate($dataCollectorMock);
    }
}
