<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Class Version20190405142626
 *
 * @package DoctrineMigrations
 */
final class Version20190405142626 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE sylius_address ADD code INT DEFAULT NULL');
        $this->addSql('ALTER TABLE sylius_customer ADD code INT DEFAULT NULL');
        $this->addSql('CREATE UNIQUE INDEX customer_code_idx ON sylius_customer (code)');
        $this->addSql('CREATE UNIQUE INDEX address_code_idx ON sylius_address (code)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('DROP INDEX address_code_idx ON sylius_address');
        $this->addSql('DROP INDEX customer_code_idx ON sylius_customer');
        $this->addSql('ALTER TABLE sylius_customer DROP code');
        $this->addSql('ALTER TABLE sylius_address DROP code');
    }
}
