<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Tests\Services\CustomerGroup\Version1;

use Doctrine\DBAL\Connection;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManager;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\Services\CustomerGroup\Version1\CustomerGroupServiceHandler;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Component\Customer\Model\CustomerGroupInterface;
use Sylius\Component\Resource\Factory\FactoryInterface as ResourceFactory;

/**
 * Class CustomerGroupServiceHandlerTest
 *
 * @package Lifestyle\Sylius\Account\Consumer\Tests\Services\CustomerGroup\Version1
 */
class CustomerGroupServiceHandlerTest extends TestCase
{
    public function testIsResponsibleTrue()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('className'))->willReturn('CustomerGroup');

        $customerGroupFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new CustomerGroupServiceHandler($customerGroupFactoryMock, $customerGroupRepositoryMock, $customerGroupManagerMock, $loggerMock);

        $this->assertTrue($testObj->isResponsible($dataCollectorMock));
    }

    public function testIsResponsibleFalse()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('className'))->willReturn('InvalidClass');

        $customerGroupFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new CustomerGroupServiceHandler($customerGroupFactoryMock, $customerGroupRepositoryMock, $customerGroupManagerMock, $loggerMock);

        $this->assertFalse($testObj->isResponsible($dataCollectorMock));
    }

    public function testCreateOrUpdateCreate()
    {
        $code = 123;
        $name = 'customerGroup123';

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(4))->method('getItemValue')
            ->withConsecutive([$this->equalTo('id')], [$this->equalTo('id')], [$this->equalTo('name')], [$this->equalTo('name')])
            ->willReturnOnConsecutiveCalls($code, $code, $name, $name);

        $newCustomerGroupEntityMock = $this->getMockBuilder(CustomerGroupInterface::class)->disableOriginalConstructor()->getMock();
        $newCustomerGroupEntityMock->expects($this->once())->method('setCode')->with($this->equalTo($code));
        $newCustomerGroupEntityMock->expects($this->once())->method('setName')->with($this->equalTo($name));

        $customerGroupFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerGroupFactoryMock->expects($this->once())->method('createNew')->willReturn($newCustomerGroupEntityMock);

        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock->expects($this->once())->method('findOneBy')->willReturn(null);
        $customerGroupRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($newCustomerGroupEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerGroupManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerGroupManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new CustomerGroupServiceHandler($customerGroupFactoryMock, $customerGroupRepositoryMock, $customerGroupManagerMock, $loggerMock);

        $testObj->createOrUpdate($dataCollectorMock);
    }

    public function testCreateOrUpdateUpdate()
    {
        $code = 123;
        $name = 'customerGroup123';

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(3))->method('getItemValue')
            ->withConsecutive([$this->equalTo('id')], [$this->equalTo('name')], [$this->equalTo('name')])
            ->willReturnOnConsecutiveCalls($code, $name, $name);

        $customerGroupEntityMock = $this->getMockBuilder(CustomerGroupInterface::class)->disableOriginalConstructor()->getMock();
        $customerGroupEntityMock->expects($this->never())->method('setCode');
        $customerGroupEntityMock->expects($this->once())->method('setName')->with($this->equalTo($name));

        $customerGroupFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerGroupFactoryMock->expects($this->never())->method('createNew');

        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock->expects($this->once())->method('findOneBy')->willReturn($customerGroupEntityMock);
        $customerGroupRepositoryMock->expects($this->once())->method('add')->with($this->equalTo($customerGroupEntityMock));

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerGroupManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerGroupManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $testObj = new CustomerGroupServiceHandler($customerGroupFactoryMock, $customerGroupRepositoryMock, $customerGroupManagerMock, $loggerMock);

        $testObj->createOrUpdate($dataCollectorMock);
    }

    public function testCreateOrUpdateException()
    {
        $code = 123;
        $errorMessage = 'someTestError';

        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->exactly(1))->method('getItemValue')
            ->withConsecutive([$this->equalTo('id')])
            ->willReturnOnConsecutiveCalls($code);

        $customerGroupFactoryMock = $this->getMockBuilder(ResourceFactory::class)->disableOriginalConstructor()->getMock();
        $customerGroupFactoryMock->expects($this->never())->method('createNew');

        $customerGroupRepositoryMock = $this->getMockBuilder(EntityRepository::class)->disableOriginalConstructor()->getMock();
        $customerGroupRepositoryMock->expects($this->once())->method('findOneBy')->willThrowException(new \Exception($errorMessage));
        $customerGroupRepositoryMock->expects($this->never())->method('add');

        // mock database reconnect stuff
        $dbalConnectionMock = $this->getMockBuilder(Connection::class)->disableOriginalConstructor()->getMock();
        $dbalConfigurationMock = $this->getMockBuilder(Configuration::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock = $this->getMockBuilder(EntityManager::class)->disableOriginalConstructor()->getMock();
        $customerGroupManagerMock->expects($this->any())->method('getConnection')->willReturn($dbalConnectionMock);
        $customerGroupManagerMock->expects($this->any())->method('getConfiguration')->willReturn($dbalConfigurationMock);
        $customerGroupManagerMock->expects($this->any())->method('isOpen')->willReturn(true);

        $loggerMock = $this->getMockBuilder(LoggerInterface::class)->disableOriginalConstructor()->getMock();
        $loggerMock->expects($this->once())->method('error')->with($this->equalTo($errorMessage));
        $testObj = new CustomerGroupServiceHandler($customerGroupFactoryMock, $customerGroupRepositoryMock, $customerGroupManagerMock, $loggerMock);

        $testObj->createOrUpdate($dataCollectorMock);
    }
}
