<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Admin;

use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

/**
 * Class AdminLocationMenuListener
 *
 * @package Lifestyle\Sylius\Account\Consumer\Admin
 */
class AdminLocationMenuListener
{
    /**
     * @param MenuBuilderEvent $event
     */
    public function addAdminMenuItems(MenuBuilderEvent $event): void
    {
        //get the admin backend customers menu
        $customers = $event->getMenu()->getChild('customers');

        $customers
            ->addChild('location', ['route' => 'lifestyle_admin_location_index'])
            ->setLabel('lifestyle.ui.locations')
            ->setLabelAttribute('icon', 'location arrow')
        ;
    }
}
