<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;

/**
 * Class AddressPublishHandler
 *
 * @package Lifestyle\Sylius\Account\Consumer\MessageHandler
 */
class AddressPublishHandler implements HandlerInterface
{
    use MessageResponsibilityTrait;
    use MessageHandlerTrait;

    /**
     * @inheritDoc
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        $processed = false;
        if ($this->isResponsible($dataCollector)) {
            foreach ($this->messageHandler as $handler) {
                if ($handler->isResponsible($dataCollector)) {
                    $handler->createOrUpdate($dataCollector);
                    $processed = true;
                }
            }
        }

        return $processed;
    }
}
