<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Services\Shared\Helper;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\OptimisticLockException;
use Lifestyle\Sylius\Account\Consumer\Exception\DatabaseException;

/**
 * Trait DatabaseTrait
 *
 * @package Lifestyle\Sylius\Account\Consumer\Services\Shared\Helper
 */
trait DatabaseTrait
{
    /**
     * @param EntityManager $entityManager
     *
     * @return EntityManager
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     */
    private function getClearedEntityManager(EntityManager $entityManager): EntityManager
    {
        $connection = $entityManager->getConnection();
        $configuration = $entityManager->getConfiguration();

        // Reconnect
        if (!$connection->ping()
            || !$connection->isConnected()
        ) {
            $connection->close();
            $connection->connect();
        }

        // Create new entity manager, if is closed
        if (!$entityManager->isOpen()) {
            $entityManager = $entityManager->create($connection, $configuration);
        }

        // Remove every unsaved entities from previous actions
        $entityManager->clear();

        return $entityManager;
    }
}
