<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Tests\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\AddressUnpublishHandler;
use Lifestyle\Sylius\Account\Consumer\Services\Address\Version1\AddressServiceHandler;
use PHPUnit\Framework\TestCase;

/**
 * Class AddressUnpublishHandlerTest
 *
 * @package Lifestyle\Sylius\Account\Consumer\Tests\MessageHandler
 */
class AddressUnpublishHandlerTest extends TestCase
{
    public function testHandleTrue()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('address:unpublish');

        $messageHandlerMock = $this->getMockBuilder(AddressServiceHandler::class)->disableOriginalConstructor()->getMock();
        $messageHandlerMock->expects($this->once())->method('isResponsible')->with($this->equalTo($dataCollectorMock))->willReturn(true);
        $messageHandlerMock->expects($this->once())->method('delete')->with($this->equalTo($dataCollectorMock));

        $testObj = new AddressUnpublishHandler();
        $testObj->addResponsibleEvent('address:unpublish');
        $testObj->addMessageHandler($messageHandlerMock);

        $this->assertTrue($testObj->handle($dataCollectorMock));
    }

    public function testHandleFalseByNotResponsible()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('invalid:event');

        $testObj = new AddressUnpublishHandler();
        $testObj->addResponsibleEvent('address:unpublish');

        $this->assertFalse($testObj->handle($dataCollectorMock));
    }

    public function testHandleFalseByMessageHandlerNotResponsible()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('address:unpublish');

        $messageHandlerMock = $this->getMockBuilder(AddressServiceHandler::class)->disableOriginalConstructor()->getMock();
        $messageHandlerMock->expects($this->once())->method('isResponsible')->with($this->equalTo($dataCollectorMock))->willReturn(false);
        $messageHandlerMock->expects($this->never())->method('createOrUpdate');

        $testObj = new AddressUnpublishHandler();
        $testObj->addResponsibleEvent('address:unpublish');
        $testObj->addMessageHandler($messageHandlerMock);

        $this->assertFalse($testObj->handle($dataCollectorMock));
    }
}
