<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Account\Consumer\Tests\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Account\Consumer\MessageHandler\LocationPublishHandler;
use Lifestyle\Sylius\Account\Consumer\Services\Location\Version1\LocationServiceHandler;
use PHPUnit\Framework\TestCase;

/**
 * Class LocationPublishHandlerTest
 *
 * @package Lifestyle\Sylius\Account\Consumer\Tests\MessageHandler
 */
class LocationPublishHandlerTest extends TestCase
{
    public function testHandleTrue()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('location:publish');

        $messageHandlerMock = $this->getMockBuilder(LocationServiceHandler::class)->disableOriginalConstructor()->getMock();
        $messageHandlerMock->expects($this->once())->method('isResponsible')->with($this->equalTo($dataCollectorMock))->willReturn(true);
        $messageHandlerMock->expects($this->once())->method('createOrUpdate')->with($this->equalTo($dataCollectorMock));

        $testObj = new LocationPublishHandler();
        $testObj->addResponsibleEvent('location:publish');
        $testObj->addMessageHandler($messageHandlerMock);

        $this->assertTrue($testObj->handle($dataCollectorMock));
    }

    public function testHandleFalseByNotResponsible()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('invalid:event');

        $testObj = new LocationPublishHandler();
        $testObj->addResponsibleEvent('location:publish');

        $this->assertFalse($testObj->handle($dataCollectorMock));
    }

    public function testHandleFalseByMessageHandlerNotResponsible()
    {
        $dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->disableOriginalConstructor()->getMock();
        $dataCollectorMock->expects($this->once())->method('getItemValue')->with($this->equalTo('event'))->willReturn('location:publish');

        $messageHandlerMock = $this->getMockBuilder(LocationServiceHandler::class)->disableOriginalConstructor()->getMock();
        $messageHandlerMock->expects($this->once())->method('isResponsible')->with($this->equalTo($dataCollectorMock))->willReturn(false);
        $messageHandlerMock->expects($this->never())->method('createOrUpdate');

        $testObj = new LocationPublishHandler();
        $testObj->addResponsibleEvent('location:publish');
        $testObj->addMessageHandler($messageHandlerMock);

        $this->assertFalse($testObj->handle($dataCollectorMock));
    }
}
