# DataCollector Model
This package provides restriction to access certain areas of the admin backend based on groups.
 

## Installation

**1 . Make sure you've added the repository in your composer.json file:**
 
 ```json
     {
         "repositories": [
            {
                "type": "git",
                "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusadminviewrestrictionplugin.git"
            }
         ]
     }
 ```

**2. Require the bundle with Composer:**
```bash
$ composer require lifestyle/sylius-admin-view-restriction-plugin
```

**3. Add configuration to your project ( file: config/packages/lifestyle.yaml)**
```bash
    - { resource: "@LifeStyleSyliusAdminViewRestrictionPlugin/Resources/config/config.yml"}
```
Create file life_style_view_admin_restriction_plugin.yaml under config/packages/ with following content:
```bash
life_style_sylius_admin_view_restriction:
    backend_groups:
        system_global_order_only_group: "ORDER_ONLY"
        system_global_admin_group: "ADMIN"
```

**4. Assign group to backend user**
This command allows you to assign groups to certain users. User will be identified by mail. The group name has to match 
the once previously set in the config file 
```bash
$ php bin/console sylius:user:promote 
```
**5. Firewall settings (not in bundle yet)**
Make it 100% save and sound you can adjust your firewall settings accordingly:
config/packages/security.yaml

parameters:
```bash
sylius.security.admin_product_id_regex: "[0-9]+"
```
access_control:
```bash
        # Disallow product delete and variant delete if you are no ADMIN :) 
        - { path: "%sylius.security.admin_regex%/products/%sylius.security.admin_product_id_regex%", roles: [ROLE_ADMINISTRATION_ACCESS, BMZ_ADMIN], methods: [DELETE] }
        - { path: "%sylius.security.admin_regex%/products/%sylius.security.admin_product_id_regex%/variants/%sylius.security.admin_product_id_regex%", roles: [ROLE_ADMINISTRATION_ACCESS, BMZ_ADMIN], methods: [DELETE] }
        # Disallow attributes delete / bulk delete if you are no ADMIN :) 
        - { path: "%sylius.security.admin_regex%/product-attributes/%sylius.security.admin_product_id_regex%", roles: [ROLE_ADMINISTRATION_ACCESS, BMZ_ADMIN], methods: [DELETE] }
        # Disallow options delete / bulk delete if you are no ADMIN :) 
        - { path: "%sylius.security.admin_regex%/product-options/%sylius.security.admin_product_id_regex%", roles: [ROLE_ADMINISTRATION_ACCESS, BMZ_ADMIN], methods: [DELETE] }
        # Disallow Taxon delete if you are no ADMIN :)
        - { path: "%sylius.security.admin_regex%/taxon/%sylius.security.admin_product_id_regex%", roles: [ROLE_ADMINISTRATION_ACCESS, BMZ_ADMIN], methods: [DELETE] }
```
