<?php

declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\AdminViewRestrictionPlugin\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\Yaml\Yaml;

/**
 * Class LifeStyleSyliusAdminViewRestrictionExtension
 * @package LifeStyle\Sylius\AdminViewRestrictionPlugin\DependencyInjection
 */
class LifeStyleSyliusAdminViewRestrictionExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function prepend(ContainerBuilder $container)
    {
        $config = Yaml::parse(file_get_contents(__DIR__ . '/../Resources/config/config.yml'));

        if (count($config) > 0) {
            foreach ($config as $key => $configuration) {
                if (is_array($configuration) && count($configuration) > 0) {
                    $container->prependExtensionConfig($key, $configuration);
                }
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        if(!isset($config['backend_groups'])) {
            throw new \InvalidArgumentException(
                'The "backend_groups" option must be set'
            );
        }

        $container->getDefinition(Configuration::class)->setArguments(
            [
                $config['backend_groups']['system_global_order_only_group'],
                $config['backend_groups']['system_global_admin_group']
            ]
        );
    }
}
