<?php

declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\AdminViewRestrictionPlugin\EventListener;

use LifeStyle\Sylius\AdminViewRestrictionPlugin\Configuration\Configuration;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;
use Symfony\Component\Security\Core\Security;

/**
 * Class AdminMenuUpdateListener
 * @package LifeStyle\Sylius\AdminViewRestrictionPlugin\EventListener
 */
final class AdminMenuUpdateListener
{
    /**
     * @var Security
     */
    private $security;

    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * AdminMenuUpdateListener constructor.
     * @param Security $security
     * @param Configuration $
     */
    public function __construct(Security $security, Configuration $configuration)
    {
        $this->security = $security;
        $this->configuration = $configuration;
    }

    /**
     * @param MenuBuilderEvent $event
     */
    public function updateAdminMenuItems(MenuBuilderEvent $event): void
    {
        $user = $this->security->getUser();
        $menu = $event->getMenu();

        if (in_array($this->configuration->getOderOnlyGroup(), $user->getRoles())) {
            $menu->removeChild('configuration');
            $menu->removeChild('catalog');
            $menu->removeChild('marketing');
            $menu->removeChild('customers');
        } elseif (!in_array($this->configuration->getAdminGroup(), $user->getRoles())) {
            $catalog = $menu->getChild('catalog');
            $catalog->removeChild('options');
            $catalog->removeChild('taxons');
            $catalog->removeChild('attributes');
            $catalog->removeChild('inventory');
            $catalog->removeChild('association_types');

            $marketing = $menu->getChild('marketing');
            $marketing->removeChild('product_reviews');

            $config = $menu->getChild('configuration');
            $config->removeChild('admin_users');
            $config->removeChild('channels');
            $config->removeChild('countries');
            $config->removeChild('currencies');
            $config->removeChild('zones');
            $config->removeChild('locales');
            $config->removeChild('tax_rates');
            $config->removeChild('tax_categories');
            $config->removeChild('exchange_rates');
            $config->removeChild('payment_methods');
        }

    }
}
