<?php

declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\AdminViewRestrictionPlugin\EventListener;

use LifeStyle\Sylius\AdminViewRestrictionPlugin\Configuration\Configuration;
use Sonata\BlockBundle\Event\BlockEvent;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Security\Core\Security;

/**
 * Class AdminProductShowUpdateListener
 * @package LifeStyle\Sylius\AdminViewRestriction\EventListener
 */
final class AdminProductShowUpdateListener
{
    /**
     * @var Security
     */
    private $security;

    /**
     * @var ContainerInterface
     */
    private $configuration;

    /**
     * AdminProductShowUpdateListener constructor.
     * @param Security $security
     * @param Configuration $configuration
     */
    public function __construct(Security $security, Configuration $configuration)
    {
        $this->security = $security;
        $this->configuration = $configuration;
    }

    /**
     * @param BlockEvent $event
     */
    public function updateAdminProductShow(BlockEvent $event): void
    {
        $this->updateView($event);
    }

    /**
     * @param BlockEvent $event
     */
    public function updateAdminProductVariantShow(BlockEvent $event): void
    {
        $this->updateView($event);
    }

    /**
     * @desc disable all things pimcore would do
     * @param BlockEvent $event
     */
    private function updateView(BlockEvent $event): void
    {
        $user = $this->security->getUser();
        if(!in_array($this->configuration->getAdminGroup(), $user->getRoles())) {
            $resources = $event->getSetting("resources");

            foreach($resources->getDefinition()->getActionGroups() as $group) {
                if($group->hasAction('delete') && ($group->getName() == 'item' || $group->getName() == 'bulk')) {
                    $group->getAction("delete")->setEnabled(false);
                }
                elseif($group->hasAction('create') && $group->getName() == 'main') {
                    $group->getAction("create")->setEnabled(false);
                }
                elseif($group->getName() == 'subitem') {
                    $subMenu = $group->getAction('variants')->getOptions();
                    if(null !== $subMenu) {
                        unset($subMenu['links']['create']);
                        unset($subMenu['links']['generate']);
                        $group->getAction('variants')->setOptions($subMenu);
                    }

                }
            }
        }
    }
}
