<?php

declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\AdminViewRestrictionPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package LifeStyle\Sylius\AdminViewRestrictionPlugin\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @return TreeBuilder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('life_style_sylius_admin_view_restriction_plugin');
        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('backend_groups')
                    ->children()
                        ->scalarNode('system_global_order_only_group')->end()
                        ->scalarNode('system_global_admin_group')->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
