<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sylius\AdminViewRestrictionPlugin\Configuration;

/**
 * Class Configuration
 * @package LifeStyle\Sylius\AdminViewRestrictionPlugin\Configuration
 */
class Configuration
{
    /**
     * @var string|null
     */
    private $oderOnlyGroup;

    /**
     * @var string|null
     */
    private $adminGroup;

    /**
     * Configuration constructor.
     * @param string|null $oderOnlyGroup
     * @param string|null $adminGroup
     */
    public function __construct(?string $oderOnlyGroup, ?string $adminGroup)
    {
        $this->oderOnlyGroup = $oderOnlyGroup;
        $this->adminGroup = $adminGroup;
    }

    /**
     * @return string|null
     */
    public function getOderOnlyGroup(): ?string
    {
        return $this->oderOnlyGroup;
    }

    /**
     * @param string|null $oderOnlyGroup
     */
    public function setOderOnlyGroup(?string $oderOnlyGroup): void
    {
        $this->oderOnlyGroup = $oderOnlyGroup;
    }

    /**
     * @return string|null
     */
    public function getAdminGroup(): ?string
    {
        return $this->adminGroup;
    }

    /**
     * @param string|null $adminGroup
     */
    public function setAdminGroup(?string $adminGroup): void
    {
        $this->adminGroup = $adminGroup;
    }
}
