<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Asset\Entity;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface AssetStorageInterface
 * @package Lifestyle\Sylius\Asset\Entity
 */
interface AssetStorageInterface
{
    /**
     * @return int
     */
    public function getId(): int;

    /**
     * @param int $id
     */
    public function setId(int $id): void;

    /**
     * @return string
     */
    public function getResourceId(): string;

    /**
     * @param string $resourceId
     */
    public function setResourceId(string $resourceId): void;

    /**
     * @return string|null
     */
    public function getPath(): ?string;

    /**
     * @param string|null $path
     */
    public function setPath(?string $path): void;

    /**
     * @return string|null
     */
    public function getName(): ?string;

    /**
     * @param string|null $name
     */
    public function setName(?string $name): void;

    /**
     * @return \DateTime
     */
    public function getCreated(): \DateTime;

    /**
     * @param \DateTime $created
     */
    public function setCreated(\DateTime $created): void;

    /**
     * @return \DateTime
     */
    public function getUpdated(): \DateTime;

    /**
     * @param \DateTime $updated
     */
    public function setUpdated(\DateTime $updated): void;

    /**
     * @return ArrayCollection|AssetStorageMetaDataInterface[]|null
     */
    public function getMetaDatas();

    /**
     * @param AssetStorageMetaDataInterface $metaData
     */
    public function addMetaData(AssetStorageMetaDataInterface $metaData): void;
}
