<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Asset\Entity;

/**
 * Interface AssetStorageMetaDataInterface
 * @package Lifestyle\Sylius\Asset\Entity
 */
interface AssetStorageMetaDataInterface
{
    /**
     * @return string
     */
    public function getId(): string;

    /**
     * @param string $id
     */
    public function setId(string $id): void;

    /**
     * @return string
     */
    public function getLocale(): string;

    /**
     * @param string $locale
     */
    public function setLocale(string $locale): void;

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $type
     */
    public function setType(string $type): void;

    /**
     * @return string
     */
    public function getValue(): string;

    /**
     * @param string $value
     */
    public function setValue(string $value): void;

    /**
     * @return AssetStorageInterface
     */
    public function getAssetStorage(): AssetStorageInterface;

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function setAssetStorage(AssetStorageInterface $assetStorage): void;
}
