<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Asset\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;
use Lifestyle\Sylius\Asset\AssetHelper\AssetHelper;

/**
 * Class AssetUnpublishHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Lifestyle\Sylius\Asset\MessageHandler
 */
class AssetUnpublishHandler implements HandlerInterface
{
    use MessageResponsibilityTrait;

    /**
     * @var AssetHelper
     */
    private $assetHelper;

    /**
     * AssetUnpublishHandler constructor.
     * @param AssetHelper $assetHelper
     */
    public function __construct(AssetHelper $assetHelper)
    {
        $this->assetHelper = $assetHelper;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool
     * @throws \Doctrine\Common\Persistence\Mapping\MappingException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Lifestyle\Sylius\Asset\Exception\DatabaseException
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        if (!$this->isResponsible($dataCollector)) {
            return false;
        }

        $resourceId = (int)$dataCollector->getItemValue('id');

        //remove from table
        $this->assetHelper->removeAsset($resourceId);

        //we do not want to interrupt the chain so always return false
        return false;
    }
}
