<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Asset\DependencyInjection;

use Lifestyle\Sylius\Asset\MessageHandler\AssetPublishHandler;
use Lifestyle\Sylius\Asset\MessageHandler\AssetUnpublishHandler;

use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;

/**
 * Class LifestyleSyliusProductExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Lifestyle\Sylius\Asset\DependencyInjection
 */
class LifestyleSyliusAssetExtension extends Extension
{
    /**
     * @param array $configs
     * @param ContainerBuilder $container
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new XmlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))->load('services.xml');

        $this->configureMessageHandler(AssetPublishHandler::class, 'assets', 'publish', $config, $container);
        $this->configureMessageHandler(AssetUnpublishHandler::class, 'assets', 'unpublish', $config, $container);
    }

    /**
     * @param string $serviceId
     * @param string $type
     * @param string $event
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureMessageHandler(
        string $serviceId,
        string $type,
        string $event,
        array $config,
        ContainerBuilder $container
    ) {
        if (!$container->has($serviceId)) {
            return;
        }

        $definition = $container->findDefinition($serviceId);

        $responsibleEvents = isset($config[$type]['responsible_events'][$event]) ? $config[$type]['responsible_events'][$event] : [];
        foreach ($responsibleEvents as $responsibleEvent) {
            $definition->addMethodCall('addResponsibleEvent', [$responsibleEvent]);
        }
    }
}
