# Life-Style Symfony Bundle To Handle Product Updates

This bundle receives messages from rabbitMQ and updates assets in Sylius.

## Requirements

Sylius 1.3

## Installation

Install the package.

```bash
composer require lifestyle/sylius-asset-plugin
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle)  Please read their documentation.

_config/packages/lifestyle_sylius_product.yaml_
```yaml
lifestyle_sylius_asset:
  assets:
    responsible_events:
      publish: [ 'asset.image.publish', 'asset.document.publish' ]
      unpublish: [ 'asset.image.unpublish',  'asset.document.unpublish' ]

imports:
  - { resource: "@LifestyleSyliusAssetPlugin/Resources/config/config.yml" }
```

_load the bundle in bundles_
```yaml
Lifestyle\Sylius\Asset\LifestyleSyliusAssetPlugin::class => ['all' => true],
```

Don´t forget to execute the migrations to create the database table

