<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\BaseTheme\Templating\Helper;

/**
 * Interface BreadcrumbPathHelperInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\BaseTheme\Templating\Helper
 */
interface BreadcrumbPathHelperInterface
{
    /**
     * @param string $locale
     * @param string $slug Part or url
     * @param string|null $url Absolute url as alternative to slug
     * @return string
     */
    public function generate(string $locale, string $slug, ?string $url): string;
}
