<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\BaseTheme\Configuration;

/**
 * Class PluginConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\BaseTheme\Configuration
 */
class PluginConfiguration
{
    /**
     * @var bool
     */
    private $productListInSulu;

    /**
     * PluginConfiguration constructor.
     * @param bool $productListInSulu
     */
    public function __construct(bool $productListInSulu)
    {
        $this->productListInSulu = $productListInSulu;
    }

    /**
     * @return bool
     */
    public function isProductListInSulu(): bool
    {
        return $this->productListInSulu;
    }
}
