<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\BaseTheme\Twig;

use Lifestyle\Sylius\BaseTheme\Configuration\PluginConfiguration;
use Lifestyle\Sylius\BaseTheme\Templating\Helper\BreadcrumbPathHelperInterface;
use Symfony\Component\Routing\Router;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Class BreadcrumbPathExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\BaseTheme\Twig
 */
class BreadcrumbPathExtension extends AbstractExtension
{
    /**
     * @var PluginConfiguration
     */
    private $configuration;

    /**
     * @var Router
     */
    private $router;

    /**
     * @var BreadcrumbPathHelperInterface
     */
    private $breadcrumbPathHelper;

    /**
     * BreadcrumbPathExtension constructor.
     * @param PluginConfiguration $configuration
     * @param Router $router
     * @param BreadcrumbPathHelperInterface $breadcrumbPathHelper
     */
    public function __construct(
        PluginConfiguration $configuration,
        Router $router,
        BreadcrumbPathHelperInterface $breadcrumbPathHelper
    ) {
        $this->configuration = $configuration;
        $this->router = $router;
        $this->breadcrumbPathHelper = $breadcrumbPathHelper;
    }

    /**
     * @param string $locale
     * @param string $slug Part or url
     * @param string|null $url Absolute url as alternative to slug
     * @return string
     */
    public function getPath(string $locale, string $slug, ?string $url)
    {
        // Product list is handled by Sulu - implement your customized path generator
        if ($this->configuration->isProductListInSulu()) {
            return $this->breadcrumbPathHelper->generate($locale, $slug, $url);
        }

        // Sylius default
        return $this->router->generate('sylius_shop_product_index', ['slug' => $slug, '_locale' => $locale]);
    }

    /**
     * @return array|TwigFunction[]
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('ls_sylius_shop_product_list_path', [$this, 'getPath']),
        ];
    }
}
