<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Sylius\BaseTheme\EventListener;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\GetResponseForExceptionEvent;
use Symfony\Component\HttpKernel\Exception\HttpExceptionInterface;
use Symfony\WebpackEncoreBundle\Asset\EntrypointLookupInterface;

/**
 * Class ExceptionListener
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\BaseTheme\EventListener
 */
class ExceptionListener
{
    /**
     * @var EntrypointLookupInterface
     */
    private $entrypointLookup;

    /**
     * ExceptionListener constructor.
     * @param EntrypointLookupInterface $entrypointLookup
     */
    public function __construct(EntrypointLookupInterface $entrypointLookup)
    {
        $this->entrypointLookup = $entrypointLookup;
    }

    /**
     * @param GetResponseForExceptionEvent $event
     */
    public function onKernelException(GetResponseForExceptionEvent $event)
    {
        // If an exception is thrown while rendering a template, this ensures that the error page has a proper css link
        $this->entrypointLookup->reset();
    }
}
