<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Sylius\BaseTheme\Twig;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\ImageInterface;

/**
 * Class ProductImageExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Sylius\BaseTheme\Twig
 */
class ProductImageExtension extends \Twig_Extension
{
    /**
     * {@inheritdoc}
     */
    public function getFilters(): array
    {
        return [
            new \Twig_Filter('lifestyle_sylius_sort_product_images', [$this, 'sortProductImages']),
        ];
    }

    /**
     * Images of type "main" should be first in list
     *
     * @param Collection $images
     * @return Collection
     */
    public function sortProductImages(Collection $images): Collection
    {
        $iterator = $images->getIterator();

        $iterator->uasort(function(ImageInterface $a, ImageInterface $b) {
            $aType = $a->getType();
            $bType = $b->getType();
            if ($aType === $bType) {
                return 0;
            }
            return $aType === 'main' ? -1 : 1;
        });

        return new ArrayCollection(iterator_to_array($iterator));
    }
}
