/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

import $ from 'jquery';

const handleProductOptionsChange = function handleProductOptionsChange() {
    $('[name*="sylius_add_to_cart[cartItem][variant]"]').on('change', () => {
        let selector = '';

        $('#sylius-product-adding-to-cart select[data-option]').each((index, element) => {
            const select = $(element);
            const option = select.find('option:selected').val();
            selector += `[data-${select.attr('data-option')}="${option}"]`;
        });

        const $pricing = $('#sylius-variants-pricing');
        const price = $pricing.find(selector).attr('data-value');

        if (price !== undefined) {
            $('#product-price').text(price);
            $('button[type=submit]').removeAttr('disabled');
        } else {
            $('#product-price').text($pricing.attr('data-unavailable-text'));
            $('button[type=submit]').attr('disabled', 'disabled');
        }
    });
};

const handleProductVariantsChange = function handleProductVariantsChange() {
    $('[name="sylius_add_to_cart[cartItem][variant]"]').on('change', (event) => {
        const price = $(event.currentTarget).parents('tr').find('.sylius-product-variant-price').text();
        $('#product-price').text(price);
    });
};

$.fn.extend({
    variantPrices() {
        if ($('#sylius-variants-pricing').length > 0) {
            handleProductOptionsChange();
        } else if ($('#sylius-product-variants').length > 0) {
            handleProductVariantsChange();
        }
    },
});
