/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

import $ from 'jquery';

const handleProductOptionsChange = function handleProductOptionsChange() {
    $('[name*="sylius_add_to_cart[cartItem][variant]"]').on('change', () => {
        let selector = '';

        $('#sylius-product-adding-to-cart select[data-option]').each((index, element) => {
            const select = $(element);
            const option = select.find('option:selected').val();
            selector += `[data-${select.attr('data-option')}="${option}"]`;
        });

        const $pricing = $('#sylius-variants-pricing');
        const price = $pricing.find(selector).attr('data-value');
        const originalPrice =  $pricing.find(selector).attr('data-originalprice');

        originalPriceVisability(price, originalPrice);

        if (price !== undefined) {
            $('#product-price').text(price);
            $('#product-original-price').text(originalPrice);
            $('button[type=submit]').removeAttr('disabled');
        } else {
            $('#product-price').text($pricing.attr('data-unavailable-text'));
            $('#product-original-price').text(originalPrice);
            $('button[type=submit]').attr('disabled', 'disabled');
        }
    });
};

const handleProductVariantsChange = function handleProductVariantsChange() {
    $('[name="sylius_add_to_cart[cartItem][variant]"]').on('change', (event) => {
        const priceContainer = $(event.currentTarget).parents('tr').find('.sylius-product-variant-price');
        const price = priceContainer.text();
        const originalPrice = priceContainer.data('originalprice');

        $('#product-price').text(price);
        $('#product-original-price').text(originalPrice);

        originalPriceVisability(price, originalPrice);
    });
};

function originalPriceVisability(price, originalPrice){
    let rawPrice = 0;
    let rawOriginalPrice = 0;

    if ( typeof price !== 'undefined' || price !== undefined ) {
        rawPrice = Number(price.replace(/[^0-9]+/g,""));
    }

    if ( typeof originalPrice !== 'undefined' || originalPrice !== undefined ) {
        rawOriginalPrice = Number(originalPrice.replace(/[^0-9]+/g,""));
    }

    if ( rawPrice < rawOriginalPrice && rawOriginalPrice > 0 && rawPrice > 0 ) {
        $('#original-price-text').removeClass('d-none');
    } else {
        $('#original-price-text').removeClass('d-none').addClass('d-none');
    }
}

$.fn.extend({
    variantPrices() {
        if ($('#sylius-variants-pricing').length > 0) {
            handleProductOptionsChange();
        } else if ($('#sylius-product-variants').length > 0) {
            handleProductVariantsChange();
        }
    },
});
