/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

import $ from 'jquery';

const handleProductOptionsChange = function handleProductOptionsChange() {
    $('[name*="sylius_add_to_cart[cartItem][variant]"]').on('change', () => {
        let selector = '';
        const productReferenceSelector = '[data-reference="' + $(event.currentTarget).attr('data-reference') + '"]';

        $('#sylius-product-adding-to-cart select[data-option]' + productReferenceSelector).each((index, element) => {
            const select = $(element);
            const option = select.find('option:selected').val();
            selector += `[data-${select.attr('data-option')}="${option}"]`;
        });

        const $pricing = $('#sylius-variants-pricing' + productReferenceSelector);
        const priceElement = $('#product-price' + productReferenceSelector);
        const originalPriceElement = $('#product-original-price');
        const availabilityElement = $('#product-availability' + productReferenceSelector);
        let submitButtonElement = $('#sylius-product-adding-to-cart button[type=submit]' + productReferenceSelector);
        if (submitButtonElement.length === 0) {
            submitButtonElement = $('#sylius-product-adding-to-cart button[type=submit]');
        }

        const variantElement = $pricing.find(selector);

        const price = (variantElement.attr('data-value') !== undefined)? (variantElement.attr('data-value')) : $pricing.attr('data-unavailable-text');
        const submitDisabled = (variantElement.attr('data-value') !== undefined)? false : true;
        const originalPrice = variantElement.attr('data-originalprice');
        const availability = (variantElement.attr('data-availabilityIndicator') !== undefined)? variantElement.attr('data-availabilityIndicator') : '';
        const variantNumber = variantElement.attr('data-articlenumber');

        priceElement.text(price);
        if (availabilityElement.length > 0) {
            availabilityElement.html(availability);
        }

        if (originalPriceElement.length > 0) {
            originalPriceElement.text(originalPrice);
            originalPriceVisability(price, originalPrice);
        }

        if ($('#article-nr').length > 0) {
            $('#article-nr').text(variantNumber);
            articleNumberVisability(variantNumber);
        }

        submitButtonElement.attr('disabled', submitDisabled);
    });
};

const handleInvalidCombinationsByPosition = function handleInvalidCombinationsByPosition()
{
    const optionDropdowns = $('[name*="sylius_add_to_cart[cartItem][variant]"]');
    optionDropdowns.on('focus', (element) => {
        const productReferenceSelector = '[data-reference="' + $(event.currentTarget).attr('data-reference') + '"]';
        const optionDropdownsForReference = $('[name*="sylius_add_to_cart[cartItem][variant]"]' + productReferenceSelector);
        const firstOptionDropdownForReference = $('[name*="sylius_add_to_cart[cartItem][variant]"]' + productReferenceSelector + '[data-position="1"]');

        // reset (disable) all options (but not for first dropdown)
        $(optionDropdownsForReference).find('option').addClass('disabled').attr('disabled', true);
        $(firstOptionDropdownForReference).find('option').removeClass('disabled').attr('disabled', false);

        let selector = '';
        // loop all possible dropdowns
        optionDropdownsForReference.each((index, dropdownElement) => {
            // get current dropdown position
            let currentPosition = parseInt($(dropdownElement).attr('data-position'));

            // find next dropdown element
            let nextDropdown = optionDropdownsForReference.filter(function () {
                return $(this).data('position') === currentPosition + 1;
            });

            /**
             * if next dropdown element was found build up the data selector for the next dropdown
             * and activate the vaild options
             */
            if (nextDropdown.length > 0) {
                let selectedOption = $(dropdownElement).attr('data-option');
                let nextOption = $(nextDropdown).attr('data-option');
                let selectedOptionValue = $(dropdownElement).find('option:selected').val();
                selector += `[data-${selectedOption}="${selectedOptionValue}"]`;

                $(selector + productReferenceSelector).each((index, option) => {
                    let validValue = $(option).attr('data-' + nextOption);
                    $(nextDropdown).find('option[value="' + validValue + '"]').removeClass('disabled').attr('disabled', false);
                });
            }
        });
    });
};

const handleProductVariantsChange = function handleProductVariantsChange() {
    /* change product-number to variant-nmber on load in*/
    const selectedVariantOnLoad = $('[name="sylius_add_to_cart[cartItem][variant]"]:checked').
        parents('tr').
        find('.sylius-product-variant-price').
        data('articlenumber');
    articleNumberVisability(selectedVariantOnLoad);
    $('#article-nr').text(selectedVariantOnLoad);

    $('[name="sylius_add_to_cart[cartItem][variant]"]').on('change', (event) => {
        const container = $(event.currentTarget).parents('tr').find('.sylius-product-variant-price');
        const price = container.text();
        const originalPrice = container.data('originalprice');
        const variantnumber = container.data('articlenumber');
        const availability = container.data('availability-indicator');
        const availabilityElement = $('#product-availability');

        $('#product-price').text(price);
        $('#product-original-price').text(originalPrice);
        $('#article-nr').text(variantnumber);
        if (availabilityElement.length > 0) {
            availabilityElement.html(availability);
        }

        originalPriceVisability(price, originalPrice);
        articleNumberVisability(variantnumber);
    });
};

function originalPriceVisability(price, originalPrice) {
    let rawPrice = 0;
    let rawOriginalPrice = 0;

    if (typeof price !== 'undefined' || price !== undefined) {
        rawPrice = Number(price.replace(/[^0-9]+/g, ''));
    }

    if (typeof originalPrice !== 'undefined' || originalPrice !== undefined) {
        rawOriginalPrice = Number(originalPrice.replace(/[^0-9]+/g, ''));
    }

    if (rawPrice < rawOriginalPrice && rawOriginalPrice > 0 && rawPrice > 0) {
        $('#original-price-text').removeClass('d-none');
    } else {
        $('#original-price-text').removeClass('d-none').addClass('d-none');
    }
}

function articleNumberVisability(variantnumber) {
    if (typeof variantnumber !== 'undefined' && variantnumber !== undefined && variantnumber.toString().length > 0) {
        $('#articlenr-container').removeClass('d-none');
    } else {
        $('#articlenr-container').removeClass('d-none').addClass('d-none');
    }
}

$.fn.extend({
    variantPrices() {
        if ($('#sylius-variants-pricing').length > 0) {
            handleProductOptionsChange();
            handleInvalidCombinationsByPosition();
        } else if ($('#sylius-product-variants').length > 0) {
            handleProductVariantsChange();
        }
    },
});
