/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */


import './sylius/shim/shim-jquery';
import $ from 'jquery';
import './bootstrap';

/**
 * Layzysizes
 */
import '@life-style/sulu-base-theme/assets/js/theme/lazySizesConfig';
import 'lazysizes';
import 'lazysizes/plugins/bgset/ls.bgset.js';
import 'lazysizes/plugins/unveilhooks/ls.unveilhooks.js';

/**
 * Import form Sulu Base Theme
 */

import '@life-style/sulu-base-theme/assets/js/theme/scrollToTop';
import '@life-style/sulu-base-theme/assets/js/theme/breadcrumb';
import '@life-style/sulu-base-theme/assets/js/theme/scrollTo';
import '@life-style/sulu-base-theme/assets/js/theme/cookies';
import '@life-style/sulu-base-theme/assets/js/theme/navigation';
import '@life-style/sulu-base-theme/assets/js/theme/syliusStatus';

/**
 * Import custom shop files
 */
import './sylius/ShopBundle/sylius-custom-form-quantity-field';
import './sylius/ShopBundle/sylius-variant-images';
import './sylius/ShopBundle/sylius-variants-prices';

// select variant on pdp
// based on id in hash

$(function(document) {
    const $container = $('.pdp');
    const articleNumber = window.location.hash.substring(1);

    if (!$container.length) {
        return;
    }

    if (articleNumber !== '') {
        $('#sku-' + articleNumber).find('input').click();
    }

    $(document).variantPrices();
    $(document).variantImages();
});
