/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

import $ from 'jquery';

const handleProductOptionsChange = function handleProductOptionsChange() {
    $('[name*="sylius_add_to_cart[cartItem][variant]"]').on('change', () => {
        let selector = '';

        $('#sylius-product-adding-to-cart select[data-option]').each((index, element) => {
            const select = $(element);
            const option = select.find('option:selected').val();
            selector += `[data-${select.attr('data-option')}="${option}"]`;
        });

        const $pricing = $('#sylius-variants-pricing');
        const price = $pricing.find(selector).attr('data-value');
        const originalPrice = $pricing.find(selector).attr('data-originalprice');

        originalPriceVisability(price, originalPrice);

        if (price !== undefined) {
            $('#product-price').text(price);
            $('#product-original-price').text(originalPrice);
            $('button[type=submit]').removeAttr('disabled');
        } else {
            $('#product-price').text($pricing.attr('data-unavailable-text'));
            $('#product-original-price').text(originalPrice);
            $('button[type=submit]').attr('disabled', 'disabled');
        }
    });
};

const handleProductVariantsChange = function handleProductVariantsChange() {
    /* change product-number to variant-nmber on load in*/
    const selectedVariantOnLoad = $('[name="sylius_add_to_cart[cartItem][variant]"]:checked').
        parents('tr').
        find('.sylius-product-variant-price').
        data('articlenumber');
    articleNumberVisability(selectedVariantOnLoad);
    $('#article-nr').text(selectedVariantOnLoad);

    $('[name="sylius_add_to_cart[cartItem][variant]"]').on('change', (event) => {
        const container = $(event.currentTarget).parents('tr').find('.sylius-product-variant-price');
        const price = container.text();
        const originalPrice = container.data('originalprice');
        const variantnumber = container.data('articlenumber');

        $('#product-price').text(price);
        $('#product-original-price').text(originalPrice);
        $('#article-nr').text(variantnumber);

        originalPriceVisability(price, originalPrice);
        articleNumberVisability(variantnumber);
    });
};

function originalPriceVisability(price, originalPrice) {
    let rawPrice = 0;
    let rawOriginalPrice = 0;

    if (typeof price !== 'undefined' || price !== undefined) {
        rawPrice = Number(price.replace(/[^0-9]+/g, ''));
    }

    if (typeof originalPrice !== 'undefined' || originalPrice !== undefined) {
        rawOriginalPrice = Number(originalPrice.replace(/[^0-9]+/g, ''));
    }

    if (rawPrice < rawOriginalPrice && rawOriginalPrice > 0 && rawPrice > 0) {
        $('#original-price-text').removeClass('d-none');
    } else {
        $('#original-price-text').removeClass('d-none').addClass('d-none');
    }
}

function articleNumberVisability(variantnumber) {
    if (typeof variantnumber !== 'undefined' && variantnumber !== undefined && variantnumber.toString().length > 0) {
        $('#articlenr-container').removeClass('d-none');
    } else {
        $('#articlenr-container').removeClass('d-none').addClass('d-none');
    }
}

$.fn.extend({
    variantPrices() {
        if ($('#sylius-variants-pricing').length > 0) {
            handleProductOptionsChange();
        } else if ($('#sylius-product-variants').length > 0) {
            handleProductVariantsChange();
        }
    },
});
