/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */



import $ from 'jquery';
import '../shim/shim-lightbox';

const changeMainImage = function changeMainImage(newImageDiv) {
    const mainImageLink = $('a.ui.fluid.image');
    const mainImage = $('a.ui.fluid.image > img');

    const newImage = $(newImageDiv).find('img');
    const newImageLink = $(newImageDiv).find('a');

    if (newImage.length === 0 && newImageLink.length === 0) {
        mainImage.attr('src', $('div[data-product-image]').attr('data-product-image'));
        newImageLink.attr('href', $('div[data-product-link]').attr('data-product-link'));

        return;
    }

    mainImageLink.attr('href', newImageLink.attr('href'));
    mainImage.attr('src', newImage.attr('data-large-thumbnail'));
};

const handleProductOptionImages = function handleProductOptionImages() {
    let options = '';

    $('#sylius-product-adding-to-cart select').each((index, select) => {
        options += `${$(select).find('option:selected').val()} `;
    });

    const imageSources = [];
    const optionsArray = options.trim().split(' ');
    const dataVariantOptionElements = $('[data-variant-options]');
    const imageContainers = $('[data-variant-code]').closest('.ui.image');
    let mainImage;

    imageContainers.hide();
    imageContainers.find('a[data-lightbox]').attr('data-lightbox', 'hidden-image');

    dataVariantOptionElements.each((index, element) => {
        const imageOptions = $(element).attr('data-variant-options');
        const imageHasOptions = optionsArray.every(option => imageOptions.indexOf(option) > -1);

        if (imageHasOptions) {
            const imageContainer = $(element).closest('.ui.image');
            const imageSrc = imageContainer.find('img').attr('src');

            // Filter double images
            if (-1 === $.inArray(imageSrc, imageSources)) {
                imageSources.push(imageSrc);
                if (mainImage) {
                    imageContainer.show();
                    imageContainer.find('a[data-lightbox]').attr('data-lightbox', 'sylius-product-image');
                } else {
                    mainImage = imageContainer;
                }
            }
        }
    });

    changeMainImage(mainImage);
};

const hideMainImageThumb = function hideMainImageThumb() {

    const mainImageContainer = $('div[data-product-image]');
    const mainImageSrc = mainImageContainer.siblings('.ui.fluid.image').attr('href');
    const thumbnails = mainImageContainer.siblings('ul').find('.ui.image');

    thumbnails.each(function () {
        let element = $(this);
        let thumbSrc = element.find('a').attr('href');

        if(thumbSrc === mainImageSrc){
            element.hide();
            element.find('a[data-lightbox]').attr('data-lightbox', 'hidden-image');
        }
    });
};

const handleProductOptionChange = function handleProductOptionChange() {
    $('[name*="sylius_add_to_cart[cartItem][variant]"]').on('change', () => {
        handleProductOptionImages();
    });
};

const handleProductVariantImages = function handleProductVariantImages(variantElement) {
    const variantCode = $(variantElement).attr('value');
    const imageSources = [];
    const imageContainers = $('[data-variant-code]').closest('.ui.image');
    let mainImage;

    imageContainers.hide();
    imageContainers.find('a[data-lightbox]').attr('data-lightbox', 'hidden-image');

    $(`[data-variant-code*="${variantCode}"]`).each((index, element) => {
        const imageContainer = $(element).closest('.ui.image');
        const imageSrc = imageContainer.find('img').attr('src');

        // Filter double images
        if (-1 === $.inArray(imageSrc, imageSources)) {
            imageSources.push(imageSrc);
            if (mainImage) {
                imageContainer.show();
                imageContainer.find('a[data-lightbox]').attr('data-lightbox', 'sylius-product-image');
            } else {
                mainImage = imageContainer;
            }
        }
    });

    changeMainImage(mainImage);
};

const handleProductVariantChange = function handleProductVariantChange() {
    $('[name="sylius_add_to_cart[cartItem][variant]"]').on('change', (event) => {
        handleProductVariantImages($(event.currentTarget));
    });
};

$.fn.extend({
    variantImages() {
        if ($('[data-variant-options]').length > 0) {
            handleProductOptionImages();
            handleProductOptionChange();
        } else if ($('[data-variant-code]').length > 0) {
            handleProductVariantImages($('[name="sylius_add_to_cart[cartItem][variant]"]'));
            handleProductVariantChange();
        } else {
            hideMainImageThumb();
        }
    },
});

(function() {
    $(document).variantImages();
})();
