/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

/* Add .each Polyfill for IE 11 */
if ('NodeList' in window && !NodeList.prototype.forEach) {
    NodeList.prototype.forEach = function(callback, thisArg) {
        thisArg = thisArg || window;
        for (var i = 0; i < this.length; i++) {
            callback.call(thisArg, this[i], i, this);
        }
    };
}

/* Add custom Event Polyfill for IE 11 */
(function() {
    if (typeof window.Event === 'function') return false;

    function Event(event, params) {
        params = params || {bubbles: false, cancelable: false, detail: null};
        var evt = document.createEvent('Event');
        evt.initEvent(event, params.bubbles, params.cancelable, params.detail);
        return evt;
    }

    window.Event = Event;
})();

/* Add .closest Polyfill for IE 11 */
if (!Element.prototype.matches) {
    Element.prototype.matches = Element.prototype.msMatchesSelector ||
        Element.prototype.webkitMatchesSelector;
}

if (!Element.prototype.closest) {
    Element.prototype.closest = function(s) {
        var el = this;

        do {
            if (el.matches(s)) return el;
            el = el.parentElement || el.parentNode;
        } while (el !== null && el.nodeType === 1);
        return null;
    };
}

import './sylius/shim/shim-jquery';
import $ from 'jquery';
import './bootstrap';
/**
 * Layzysizes
 */
import '@life-style/sulu-base-theme/assets/js/theme/lazySizesConfig';
import 'lazysizes';
import 'lazysizes/plugins/bgset/ls.bgset.js';
import 'lazysizes/plugins/unveilhooks/ls.unveilhooks.js';
import '@life-style/sulu-base-theme/assets/js/theme/scrollToTop';
import '@life-style/sulu-base-theme/assets/js/theme/breadcrumb';
import '@life-style/sulu-base-theme/assets/js/theme/scrollTo';
import '@life-style/sulu-base-theme/assets/js/theme/cookies';
import '@life-style/sulu-base-theme/assets/js/theme/navigation';
import '@life-style/sulu-base-theme/assets/js/theme/syliusStatus';
/**
 * Import custom shop files
 */
import './sylius/ShopBundle/sylius-custom-form-quantity-field';
import './sylius/ShopBundle/sylius-variant-images';
import './sylius/ShopBundle/sylius-variants-prices';

/**
 * Import form Sulu Base Theme
 */

// select variant on pdp
// based on id in hash

$(function(document) {
    $(document).variantPrices();
    $(document).variantImages();

    const $container = $('.pdp');
    const articleNumber = window.location.hash.substring(1);

    if (!$container.length) {
        return;
    }

    if (articleNumber !== '') {
        $('#sku-' + articleNumber).find('input').click();
    }

});
