<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api;

use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\CaptureLateTransaction;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Upg\Library\PaymentMethods\Methods;

/**
 * Class CaptureLateTransactionAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api
 */
class CaptureLateTransactionAction extends CaptureTransactionAction implements ActionInterface, GatewayAwareInterface, ApiAwareInterface
{
    /**
     * @var array
     */
    protected $supportedPayments = [
        Methods::PAYMENT_METHOD_TYPE_PAYPAL,
        Methods::PAYMENT_METHOD_TYPE_SU,
        Methods::PAYMENT_METHOD_TYPE_CC,
        Methods::PAYMENT_METHOD_TYPE_CC3D,
        Methods::PAYMENT_METHOD_TYPE_BILL,
        Methods::PAYMENT_METHOD_TYPE_BILL_SECURE,
        Methods::PAYMENT_METHOD_TYPE_DD,
        Methods::PAYMENT_METHOD_TYPE_PREPAID,
    ];

    /**
     * @param CaptureLateTransaction $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $details = ArrayObject::ensureArrayObject($request->getModel());
        $details['transactionStatus'] = strtoupper($request->getToken()->getUrlParameters()['transactionStatus']?: 'MERCHANTPENDING');
        $details['paymentStatus'] = strtoupper($request->getToken()->getUrlParameters()['paymentStatus']?: 'PAYPENDING');

        parent::execute($request);
    }

    /**
     * {@inheritdoc}
     */
    public function supports($request)
    {
        return
            $request instanceof CaptureLateTransaction &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
