<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api;

use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\GetTransactionStatus;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Sylius\Component\Core\Model\OrderInterface;

/**
 * Class GetTransactionStatusAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api
 */
class GetTransactionStatusAction extends BaseApiAwareAction implements ActionInterface, GatewayAwareInterface, ApiAwareInterface
{
    /**
     * @param GetTransactionStatus $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $details = ArrayObject::ensureArrayObject($request->getModel());

        try {
            /** @var OrderInterface $order */
            $order = $request->getFirstModel()->getOrder();

            $getTransactionStatusRequest = $this->api->getRequestModelFactory()
                ->transactionStatus()
                ->setOrderID($order->getId());

            $this->api->addMacToRequest($getTransactionStatusRequest, $order->getId());

            $response = $this->api->getApiFactory()->transactionStatus($getTransactionStatusRequest)->sendRequest();
            if (0 === $response->getData('resultCode')) {
                if (null !== $response->getData('transactionStatus')) {
                    $details['transactionStatus'] = $response->getData('transactionStatus');
                }

                if (is_array($response->getData('additionalData'))) {
                    $details->defaults([
                        'additionalData' => array_merge(
                            $details->get('additionalData', []),
                            $response->getData('additionalData')
                        )
                    ]);
                }
            }
        } catch (\Exception $exception) {
            // do noting
        }
    }

    /**
     * {@inheritdoc}
     */
    public function supports($request)
    {
        return
            $request instanceof GetTransactionStatus &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
