<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore;

use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\CaptureTransaction;
use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\GetTransactionStatus;
use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\ReserveTransaction;
use Payum\Core\Action\ActionInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\GatewayAwareInterface;
use Payum\Core\GatewayAwareTrait;
use Payum\Core\Request\Capture;
use Payum\Core\Exception\RequestNotSupportedException;

/**
 * Class CaptureAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore
 */
class CaptureAction implements ActionInterface, GatewayAwareInterface
{
    use GatewayAwareTrait;

    /**
     * {@inheritDoc}
     *
     * @param Capture $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $model = ArrayObject::ensureArrayObject($request->getModel());

        // do the reserve
        $reserveTransactionRequest = new ReserveTransaction($request->getToken());
        $reserveTransactionRequest->setModel($request->getFirstModel());
        $reserveTransactionRequest->setModel($request->getModel());

        $this->gateway->execute($reserveTransactionRequest);

        // get transaction status after reserve
        $getTransactionStatusRequest = new GetTransactionStatus($request->getToken());
        $getTransactionStatusRequest->setModel($request->getFirstModel());
        $getTransactionStatusRequest->setModel($request->getModel());

        $this->gateway->execute($getTransactionStatusRequest);

        // after successfull reserve do the capture
        $captureTransactionRequest = new CaptureTransaction($request->getToken());
        $captureTransactionRequest->setModel($request->getFirstModel());
        $captureTransactionRequest->setModel($request->getModel());

        $this->gateway->execute($captureTransactionRequest);
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return
            $request instanceof Capture &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
