<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Api;

use Upg\Library\Config;
use Upg\Library\Request\Cancel;
use Upg\Library\Request\Capture;
use Upg\Library\Request\CreateTransaction;
use Upg\Library\Request\GetTransactionStatus;
use Upg\Library\Request\Objects\Address;
use Upg\Library\Request\Objects\Amount;
use Upg\Library\Request\Objects\BasketItem;
use Upg\Library\Request\Objects\Company;
use Upg\Library\Request\Objects\Person;
use Upg\Library\Request\Reserve;

/**
 * Class CrefopayApiRequestModelFactory
 *
 * @package Lifestyle\Sylius\Crefopay\Api
 */
class CrefopayApiRequestModelFactory
{
    /**
     * @var Config
     */
    protected $config;

    /**
     * CrefopayApiRequestModelFactory constructor.
     *
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * @return CreateTransaction
     */
    public function createTransaction(): CreateTransaction
    {
        return new CreateTransaction($this->config);
    }

    /**
     * @return Address
     */
    public function address(): Address
    {
        return new Address();
    }

    /**
     * @return Amount
     */
    public function amount(): Amount
    {
        return new Amount();
    }

    /**
     * @return BasketItem
     */
    public function basketItem(): BasketItem
    {
        return new BasketItem();
    }

    /**
     * @return Company
     */
    public function company(): Company
    {
        return new Company();
    }

    /**
     * @return Person
     */
    public function person(): Person
    {
        return new Person();
    }

    /**
     * @return GetTransactionStatus
     */
    public function transactionStatus(): GetTransactionStatus
    {
        return new GetTransactionStatus($this->config);
    }

    /**
     * @return Reserve
     */
    public function reserve(): Reserve
    {
        return new Reserve($this->config);
    }

    /**
     * @return Capture
     */
    public function capture(): Capture
    {
        return new Capture($this->config);
    }

    /**
     * @return Cancel
     */
    public function cancel(): Cancel
    {
        return new Cancel($this->config);
    }
}
