<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;

/**
 * Class CrefopayHostedPageBeforeGatewayConfigurationType
 */
class CrefopayHostedPageBeforeGatewayConfigurationType extends AbstractType
{
    /**
     * @inheritDoc
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('merchantId', TextType::class, [
                'label' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.merchantid',
                'translation_domain' => 'admin',
                'constraints' => [
                    new NotBlank([
                        'message' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.merchantid_notblank',
                        'groups' => 'sylius',
                    ]),
                ],
            ])
            ->add('privateKey', TextType::class, [
                'label' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.privatekey',
                'translation_domain' => 'admin',
                'constraints' => [
                    new NotBlank([
                        'message' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.privatekey_notblank',
                        'groups' => 'sylius',
                    ]),
                ],
            ])
            ->add('storeId', TextType::class, [
                'label' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.storeid',
                'translation_domain' => 'admin',
                'constraints' => [
                    new NotBlank([
                        'message' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.storeid_notblank',
                        'groups' => 'sylius',
                    ]),
                ],
            ])
            ->add('sandbox', CheckboxType::class, [
                'label' => 'sylius.form.gateway_configuration.crefopay.hostedbefore.sandbox',
                'translation_domain' => 'admin',
            ])
            ->add('authorize_mode', HiddenType::class, [
                'data' => 'use_authorize_before',
            ])
        ;
    }
}
