<?php
declare(strict_types=1);
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Class Version20190725144008
 *
 * @package DoctrineMigrations
 */
final class Version20190725144008 extends AbstractMigration
{
    /**
     * @return string
     */
    public function getDescription() : string
    {
        return '';
    }

    /**
     * @param Schema $schema
     *
     * @throws \Doctrine\DBAL\DBALException
     */
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE sylius_payment_crefopay_notification (id INT AUTO_INCREMENT NOT NULL, processed TINYINT(1) NOT NULL, tokenHash VARCHAR(64) NOT NULL, merchantId VARCHAR(32) NOT NULL, storeId VARCHAR(128) NOT NULL, orderId INT NOT NULL, captureId VARCHAR(60) NOT NULL, merchantReference VARCHAR(60) NOT NULL, paymentReference VARCHAR(255) NOT NULL, userId INT NOT NULL, amount DOUBLE PRECISION NOT NULL, currency VARCHAR(3) NOT NULL, transactionStatus VARCHAR(32) NOT NULL, orderStatus VARCHAR(32) NOT NULL, additionalData LONGTEXT NOT NULL, timestamp DATETIME NOT NULL, version VARCHAR(32) NOT NULL, errorMessage LONGTEXT NOT NULL, INDEX idx_sylius_payment_crefopay_notification_merchantReference (merchantReference), INDEX idx_sylius_payment_crefopay_notification_transactionStatus (transactionStatus), INDEX idx_sylius_payment_crefopay_notification_orderStatus (orderStatus), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
    }

    /**
     * @param Schema $schema
     *
     * @throws \Doctrine\DBAL\DBALException
     */
    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('DROP TABLE sylius_payment_crefopay_notification');
    }
}
