<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Security\Util;

use Payum\Core\Bridge\Symfony\Security\HttpRequestVerifier as BaseHttpRequestVerifier;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class HttpRequestVerifier
 *
 * @package Lifestyle\Sylius\Crefopay\Security\Util
 */
class HttpRequestVerifier extends BaseHttpRequestVerifier
{
    /**
     * @inheritDoc
     *
     * @param Request $httpRequest
     */
    public function verify($httpRequest)
    {
        $token = parent::verify($httpRequest);
        $token->setUrlParameters($httpRequest->query->all());

        return $token;
    }
}
