<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Api;

use Lifestyle\Sylius\Crefopay\Processor\NotificationProcessor;
use Upg\Library\Api\Cancel as CancelApi;
use Upg\Library\Api\Capture as CaptureApi;
use Upg\Library\Api\CreateTransaction as CreateTransactionApi;
use Upg\Library\Api\GetTransactionStatus as GetTransactionStatusApi;
use Upg\Library\Api\Reserve as ReserveApi;
use Upg\Library\Config;
use Upg\Library\Mns\Handler;
use Upg\Library\Request\Cancel as CancelRequest;
use Upg\Library\Request\Capture as CaptureRequest;
use Upg\Library\Request\CreateTransaction as CreateTransactionRequest;
use Upg\Library\Request\GetTransactionStatus as GetTransactionStatusRequest;
use Upg\Library\Request\Reserve as ReserveRequest;

/**
 * Class CrefopayApiFactory
 *
 * @package Lifestyle\Sylius\Crefopay\Api
 */
class CrefopayApiFactory
{
    /**
     * @var Config
     */
    protected $config;
    /**
     * @var NotificationProcessor
     */
    protected $notificatonProcessor;

    /**
     * CrefopayApiFactory constructor.
     *
     * @param Config $config
     */
    public function __construct(
        Config $config,
        NotificationProcessor $notificationProcessor
    ) {
        $this->config = $config;
        $this->notificationProcessor = $notificationProcessor;
    }

    /**
     * @param CreateTransactionRequest $requestModel
     *
     * @return CreateTransactionApi
     */
    public function createTransaction(CreateTransactionRequest $requestModel): CreateTransactionApi
    {
        return new CreateTransactionApi($this->config, $requestModel);
    }

    /**
     * @param GetTransactionStatusRequest $requestModel
     *
     * @return GetTransactionStatusApi
     */
    public function transactionStatus(GetTransactionStatusRequest $requestModel): GetTransactionStatusApi
    {
        return new GetTransactionStatusApi($this->config, $requestModel);
    }

    /**
     * @param ReserveRequest $requestModel
     *
     * @return ReserveApi
     */
    public function reserve(ReserveRequest $requestModel): ReserveApi
    {
        return new ReserveApi($this->config, $requestModel);
    }

    /**
     * @param CaptureRequest $requestModel
     *
     * @return CaptureApi
     */
    public function capture(CaptureRequest $requestModel): CaptureApi
    {
        return new CaptureApi($this->config, $requestModel);
    }

    /**
     * @param CancelRequest $requestModel
     *
     * @return CancelApi
     */
    public function cancel(CancelRequest $requestModel): CancelApi
    {
        return new CancelApi($this->config, $requestModel);
    }

    /**
     * @param array                 $data
     * @param NotificationProcessor $notificationProcessor
     *
     * @return Handler
     * @throws \Upg\Library\Callback\Exception\MacValidation
     * @throws \Upg\Library\Mac\Exception\MacInvalid
     * @throws \Upg\Library\Mns\Exception\ParamNotProvided
     */
    public function notificationHandler(array $data, NotificationProcessor $notificationProcessor): Handler
    {
        return new Handler($this->config, $data, $notificationProcessor);
    }

    /**
     * @return NotificationProcessor
     */
    public function notificationProcessor()
    {
        return $this->notificationProcessor;
    }
}
