###Dependencies
- Needs LifestyleSyliusPayumPlugin
- Tested with Sylius 1.4.6

###Install package with Composer
```
composer require lifestyle/sylius-crefopay-plugin
```

###Register the bundle(s) in bundles.php:
```php
return [
    ...
    Lifestyle\Sylius\Crefopay\LifestyleSyliusPayumPlugin::class => ['all' => true],
    Lifestyle\Sylius\Crefopay\LifestyleSyliusCrefopayPlugin::class => ['all' => true],
    ...
];
```

###Load the bundle config in your _sylius.yaml
```yaml
- { resource: "@LifestyleSyliusCrefopayPlugin/Resources/config/config.yml" }
```

###Add bundle routing to your sylius_shop.yaml routing
```yaml
sylius_payment_overwrite:
    resource: "@LifestyleSyliusPayumPlugin/Resources/config/routing.yml"
```

###Add notification url to your security.yaml firewall configuration
```yaml
security:
  ...
  access_control:
    ...
    # allow payum notify url without login...
    - { path: "^/payment/notify/.*", methods: [POST, GET], role: IS_AUTHENTICATED_ANONYMOUSLY }
    ...
```

###Restrictions
- Reduces payum token length to 30 chars

###Configuration
- Create a new Crefopay payment in Sylius Admin

###Migrations
- Install Migration from src\Migrations\Version20190725144008
