<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Entity;

use Sylius\Component\Resource\Model\ResourceInterface;

/**
 * Class CrefopayNotification
 *
 * @package Lifestyle\Sylius\Crefopay\Entity
 */
class CrefopayNotification implements ResourceInterface
{
    /**
     * @var int
     */
    protected $id;
    /**
     * @var bool
     */
    protected $processed = false;
    /**
     * @var string
     */
    protected $tokenHash = '';
    /**
     * @var string
     */
    protected $merchantId = '';
    /**
     * @var string
     */
    protected $storeId = '';
    /**
     * @var int
     */
    protected $orderId;
    /**
     * @var string
     */
    protected $captureId = '';
    /**
     * @var string
     */
    protected $merchantReference = '';
    /**
     * @var string
     */
    protected $paymentReference = '';
    /**
     * @var int
     */
    protected $userId;
    /**
     * @var float
     */
    protected $amount = 0.00;
    /**
     * @var string
     */
    protected $currency = '';
    /**
     * @var string
     */
    protected $transactionStatus = '';
    /**
     * @var string
     */
    protected $orderStatus = '';
    /**
     * @var string
     */
    protected $additionalData = '';
    /**
     * @var \DateTime
     */
    protected $timestamp;
    /**
     * @var string
     */
    protected $version = '';
    /**
     * @var string
     */
    protected $errorMessage = '';

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return bool
     */
    public function isProcessed(): bool
    {
        return $this->processed;
    }

    /**
     * @param bool $processed
     *
     * @return CrefopayNotification
     */
    public function setProcessed(bool $processed): CrefopayNotification
    {
        $this->processed = $processed;

        return $this;
    }

    /**
     * @return string
     */
    public function getTokenHash(): string
    {
        return $this->tokenHash;
    }

    /**
     * @param string $tokenHash
     *
     * @return CrefopayNotification
     */
    public function setTokenHash(string $tokenHash): CrefopayNotification
    {
        $this->tokenHash = $tokenHash;

        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantId(): string
    {
        return $this->merchantId;
    }

    /**
     * @param string $merchantId
     *
     * @return CrefopayNotification
     */
    public function setMerchantId(string $merchantId): CrefopayNotification
    {
        $this->merchantId = $merchantId;

        return $this;
    }

    /**
     * @return string
     */
    public function getStoreId(): string
    {
        return $this->storeId;
    }

    /**
     * @param string $storeId
     *
     * @return CrefopayNotification
     */
    public function setStoreId(string $storeId): CrefopayNotification
    {
        $this->storeId = $storeId;

        return $this;
    }

    /**
     * @return int
     */
    public function getOrderId(): int
    {
        return $this->orderId;
    }

    /**
     * @param int $orderId
     *
     * @return CrefopayNotification
     */
    public function setOrderId(int $orderId): CrefopayNotification
    {
        $this->orderId = $orderId;

        return $this;
    }

    /**
     * @return string
     */
    public function getCaptureId(): string
    {
        return $this->captureId;
    }

    /**
     * @param string $captureId
     *
     * @return CrefopayNotification
     */
    public function setCaptureId(string $captureId): CrefopayNotification
    {
        $this->captureId = $captureId;

        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantReference(): string
    {
        return $this->merchantReference;
    }

    /**
     * @param string $merchantReference
     *
     * @return CrefopayNotification
     */
    public function setMerchantReference(string $merchantReference): CrefopayNotification
    {
        $this->merchantReference = $merchantReference;

        return $this;
    }

    /**
     * @return string
     */
    public function getPaymentReference(): string
    {
        return $this->paymentReference;
    }

    /**
     * @param string $paymentReference
     *
     * @return CrefopayNotification
     */
    public function setPaymentReference(string $paymentReference): CrefopayNotification
    {
        $this->paymentReference = $paymentReference;

        return $this;
    }

    /**
     * @return int
     */
    public function getUserId(): int
    {
        return $this->userId;
    }

    /**
     * @param int $userId
     *
     * @return CrefopayNotification
     */
    public function setUserId(int $userId): CrefopayNotification
    {
        $this->userId = $userId;

        return $this;
    }

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return $this->amount;
    }

    /**
     * @param float $amount
     *
     * @return CrefopayNotification
     */
    public function setAmount(float $amount): CrefopayNotification
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency(): string
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     *
     * @return CrefopayNotification
     */
    public function setCurrency(string $currency): CrefopayNotification
    {
        $this->currency = $currency;

        return $this;
    }

    /**
     * @return string
     */
    public function getTransactionStatus(): string
    {
        return $this->transactionStatus;
    }

    /**
     * @param string $transactionStatus
     *
     * @return CrefopayNotification
     */
    public function setTransactionStatus(string $transactionStatus): CrefopayNotification
    {
        $this->transactionStatus = $transactionStatus;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrderStatus(): string
    {
        return $this->orderStatus;
    }

    /**
     * @param string $orderStatus
     *
     * @return CrefopayNotification
     */
    public function setOrderStatus(string $orderStatus): CrefopayNotification
    {
        $this->orderStatus = $orderStatus;

        return $this;
    }

    /**
     * @return string
     */
    public function getAdditionalData(): string
    {
        return $this->additionalData;
    }

    /**
     * @param string $additionalData
     *
     * @return CrefopayNotification
     */
    public function setAdditionalData(string $additionalData): CrefopayNotification
    {
        $this->additionalData = $additionalData;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTimestamp(): \DateTime
    {
        return $this->timestamp;
    }

    /**
     * @param \DateTime $timestamp
     *
     * @return CrefopayNotification
     */
    public function setTimestamp(\DateTime $timestamp): CrefopayNotification
    {
        $this->timestamp = $timestamp;

        return $this;
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @param string $version
     *
     * @return CrefopayNotification
     */
    public function setVersion(string $version): CrefopayNotification
    {
        $this->version = $version;

        return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage(): string
    {
        return $this->errorMessage;
    }

    /**
     * @param string $errorMessage
     *
     * @return CrefopayNotification
     */
    public function setErrorMessage(string $errorMessage): CrefopayNotification
    {
        $this->errorMessage = $errorMessage;

        return $this;
    }
}
