<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */
namespace Lifestyle\Sylius\Crefopay\Security\Util;

use Payum\Core\Security\Util\Random;

/**
 * Class RandomTokenGenerator
 *
 * Uses the random string from Payum Random Generator => reduce it to max length
 *
 * @package Lifestyle\Sylius\Crefopay\Security\Util
 */
class RandomTokenGenerator
{
    /**
     * @param $length
     *
     * @return string
     */
    public static function generateToken($length)
    {
        return substr(Random::generateToken(), 0, $length);
    }
}
