<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api;

use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\ExternalPaymentSuccess;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Payum\Core\Reply\HttpRedirect;
use Sylius\Component\Core\Model\OrderInterface;

/**
 * Class ExternalPaymentSuccessAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api
 */
class ExternalPaymentSuccessAction extends BaseApiAwareAction implements ActionInterface, GatewayAwareInterface, ApiAwareInterface
{
    /**
     * @param ExternalPaymentSuccess $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $details = ArrayObject::ensureArrayObject($request->getModel());

        /** @var OrderInterface $order */
        $order = $request->getFirstModel()->getOrder();

        $details['externalPaymentSuccess'] = true;

        // invalidate token
        $this->api->getPayum()->getHttpRequestVerifier()->invalidate($request->getToken());

        // redirect to sylius_shop_order_pay
        throw new HttpRedirect($this->api->getRouter()->generate('sylius_shop_order_pay', ['tokenValue' => $order->getTokenValue()]));
    }

    /**
     * {@inheritdoc}
     */
    public function supports($request)
    {
        return
            $request instanceof ExternalPaymentSuccess &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
