<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api;

use Lifestyle\Sylius\Crefopay\Request\HostedPageBefore\Api\ResetTransaction;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\GatewayAwareInterface;
use Sylius\Component\Core\Model\OrderInterface;

/**
 * Class ResetTransactionAction
 *
 * @package Lifestyle\Sylius\Crefopay\Action\HostedPageBefore\Api
 */
class ResetTransactionAction extends BaseApiAwareAction implements ActionInterface, GatewayAwareInterface, ApiAwareInterface
{
    /**
     * @param ResetTransaction $request
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);
        $details = ArrayObject::ensureArrayObject($request->getModel());

        /** @var OrderInterface $order */
        $order = $request->getFirstModel()->getOrder();
        // reset order state to cart
        $order->setState('cart');
        $order->setCheckoutState('payment_selected');
        // reset payment state to cart
        $request->getFirstModel()->setState('cart');

        // just reset some payment state values
        $details['reserved'] = false;
        $details['captured'] = false;
        $details['transactionStatus'] = '';
        $details['paymentStatus'] = '';
    }

    /**
     * {@inheritdoc}
     */
    public function supports($request)
    {
        return
            $request instanceof ResetTransaction &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
